
  #include <stdio.h>
  #include <stdlib.h>
  #include <windows.h>
  #include "tiny/tinyptc.h"

  #define NB_Points 100

  int sideFunction ( const unsigned char * point, const int index0, const int index1, const int index2 )
   {
    return ( point[index1+0] - point[index0+0] ) * ( point[index2+1] - point[index0+1] )
         - ( point[index1+1] - point[index0+1] ) * ( point[index2+0] - point[index0+0] );
   }

  int main ( int argc, char ** argv )
   {
    // variables
    int buffer[320*200];
    unsigned char point [NB_Points*2];
    unsigned char inHull[NB_Points*2];
    int i,j,k,l;

    // read the datas
    FILE * file = (FILE *) fopen ("../a", "rb" );
    fread ( point, NB_Points, 2, file );
    fclose ( file );

    // consider points are all in the convex hull
    for ( i=0; i<NB_Points*2; i+=2 )
      inHull[i] = 1;

    // remove unwanted points
    for ( i=0; i<NB_Points*2; i+=2 )
      for ( j=0; j<NB_Points*2; j+=2 )
        for ( k=j+2; k<NB_Points*2; k+=2 )
          for ( l=k+2; l<NB_Points*2; l+=2 )
           {
            int result1;
            int result2;
            int result3;
            int changed = 0;

            // test i among each triangle
            result1 = sideFunction ( point, j, k, i );
            result2 = sideFunction ( point, k, l, i );
            result3 = sideFunction ( point, l, j, i );

            // remove point if in the triangle
            if ( result1 * result2 > 0 )
              if ( result2 * result3 > 0 )
               {
                inHull[i] = 0;
                changed = 1;
               }

            // printf ( "i(%04x) j(%04x) k(%04x) l(%04x) - %08x-%08x-%08x : %s\n", i, j, k, l, result1, result2, result3, changed ? "yes" : "no" );
           }

    // Display the vertices
    memset ( buffer, 0, 320*200*4 );
    for ( i=0; i<NB_Points*2; i+=2 )
      buffer[point[i] + point[i+1]*320] = inHull[i] ? 0xffffffff : 0x0000ff00;

    ptc_open ( "my" , 320, 200 );
    while ( 1 )
     {
      ptc_update ( buffer );
      Sleep ( 5 );
     }
    ptc_close ( );

    return 0;
   }
